/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// SquareBolt.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "SquareBolt.h"
#include "section.h"

#include "funcheader.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSquareBolt dialog


CSquareBolt::CSquareBolt(CWnd* pParent /*=NULL*/)
	: CDialog(CSquareBolt::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSquareBolt)
	m_boltLength = 0.0;
	m_boltDiameter = 0.0;
	//}}AFX_DATA_INIT
}


void CSquareBolt::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSquareBolt)
	DDX_Text(pDX, IDC_SBEDIT1, m_boltLength);
	DDV_MinMaxDouble(pDX, m_boltLength, 1.e-003, 1000.);
	DDX_Text(pDX, IDC_SBEDIT2, m_boltDiameter);
	DDV_MinMaxDouble(pDX, m_boltDiameter, 1.e-003, 1000.);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSquareBolt, CDialog)
	//{{AFX_MSG_MAP(CSquareBolt)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSquareBolt message handlers

void CSquareBolt::OnOK() 
{

	HRESULT status = CONV_SUCCESS;
	UpdateData(TRUE);

	if(m_boltLength >0 && m_boltDiameter > 0 ) {
		
		status = CreateSquareBolt(m_boltLength/1000, m_boltDiameter/1000);
		if(status != 0){
			AfxMessageBox("CreateSquareBolt failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");
	
	CDialog::OnOK();
}
